#!/bin/bash -i
shopt -s expand_aliases
if [ -f ~/.bash_aliases ]; then
    . ~/.bash_aliases
fi
COUNTDOWN=true
command countdown 0 > /dev/null && COUNTDOWN="countdown 3"

# nasauta.sh su 28.6.2015 07.21.32 +0300
#   - transmission-daemonin pysäytys siirron ajaksi
#
# su 31.5.2015 13.39.04 +0300
#   - viikottainen.sh->nasauta.sh
#   - kohteeksi nas
#
# to 25.12.2014 14.38.06 +0200
#	- shellcheck tyytyväiseksi
#
# su 17.8.2014 19.43.41 +0300
#	- --delete videoille
#
# ma 14.7.2014 16.01.33 +0300
#	- videoitten bakuppaus erilliseen alihakemistoon
#
# su 6.4.2014 17.19.53 +0300
#	- U1 -> ownCloud
#
# to 26.12.2013 14.45.58 +0200
#	- ei ilmoituskuplaa jos ei työpöytää
#
# ke 11.12.2013 21.59.59 +0200
#	- command whichin sijasta
#
# su 18.8.2013 21.08.24 +0300
#	- pari kertaa puuttuva || exit 1
#
# pe 10. toukokuuta 2013 kello 14.31 
#	- lue työpöydän varmuuskopiosta poisjätettävät tiedostosta
#	  ($HOME/.config/viikottainen/excludes)
#
# to 2.5.2013 19.41.32 +0300
#	- funktionalismia
#	- jatkamistoiminto (--resume)
#	- rsync-vanishedista eroon, tunnistaa nyt myös levytäynnä
#
# su 28.4.2013 21.11.15 +0300
#	- umount 12 kertaa tarvittaessa, turpakii
#
# to 11.4.2013 19.42.49 +0300
#	- umount -l^w
#
# to 4.4.2013 21.12.45 +0300
#	- umount -l
#
# to 21.2.2013 14.16.02 +0200
#	- rm -rf .Trash-1000
#	- varmistaa että kohdelevy on liitetty
#
# ke 16.1.2013 21.54.15 +0200
#	- palvelinbackup.sh-eriytys
#	- btrfs, levy- ja hakemistorakennepäivitys
#
# ke 26.12.2012 21.03.13 +0200
#	- --kotivain myös gedit-roskanpoistossa
#	- oikeasti toimiva U1-backup
#	- notify-ilmoitus valmistumisesta
#
# ma 12.12.2011 18.19.50 +0200
#	- kopsaa myös U1-hakemisto
#	- kopsaa myös /usr/local
#
# ke 30.11.2011 11.58.45 +0200
#	- shopt -s expand_aliases
#	- avaintietokanta nyt pilvessä, varmuuskopio tikulla
#
# ti 17.5.2011 09.50.51 +0300
#	- Private eri asemalle
#	- palvelinosuus erikseen
#
# to 5.5.2011 12.22.57 +0300
#	- tämä POS nyt jopa toimii
#
# ti 3.5.2011 14.15.33 +0300
#	- konfattavuutta++
#
# ti 3.5.2011 14.03.16 +0300
#	- siivousta
#	- irrotin turhan paljastavan ilmoitusmekanismin omaksi pieneksi
#	  aliohjelmakseen
#
# ti 3.5.2011 13.33.21 +0300

TPSUBDIR=Työpöytä
VIDEOSUBDIR=Työpöytä/Video
TYOPOYTA=$HOME/$TPSUBDIR
TYOPOYTA=${TYOPOYTA%%/}
KOHDEROOT=${TYOPOYTA}/Yksityinen/Data/Backup
KOHDEROOT=${KOHDEROOT%%/}
KOHDEETC=${KOHDEROOT}/Järjestelmä/Asetustiedostot/etc-$(datefilename).tar.bz2
KOHDEUSRL=${KOHDEROOT}/Järjestelmä/Paikallistiedostot/usr-local-$(datefilename).tar.bz2
KOHDEHOME=${KOHDEROOT}/Home
KOHDEPILVI=${KOHDEROOT}/ownCloud
CLOUDSUBDIR=ownCloud
SNSUBDIR=.Backup
SNAPROOT=${HOME}/${SNSUBDIR}
KOHDETPSV=Työpöytä
KOHDETYOP=${SNAPROOT}
KOHDEVIDEO=${SNAPROOT}/Työpöytä/Video
MOI=$(whoami)
RESUMEFILE=/tmp/viikottainen-resume-$MOI

# pick up some rsync exit codes
VANISHED=24
RSYNCOUTPUT=$(mktemp)

# set up excludes & includes
EXCLUDES=$HOME/.config/nasauta/excludes
[ ! -r "$EXCLUDES" ] && EXCLUDES=/dev/null
VIDEOINCLUDES=$HOME/.config/nasauta/videoincludes
[ ! -r "$VIDEOINCLUDES" ] && VIDEOINCLUDES=/dev/null

function die() {
  [ "$1" -gt 0 ] && echo "$1" > "$RESUMEFILE"
  rm -f "$RSYNCOUTPUT"
  exit "$1"
}

function mount_snapshot_root() {
  mountpoint -q "$SNAPROOT" || { \
    echo -n "Liitän kohdeaseman ($SNAPROOT). "
#    echo -n "Anna salasanasi: "
    mount "$SNAPROOT" > /dev/null || { \
        echo ""
        echo -n "Kohdeasema $SNAPROOT ei ole liitettynä "
        echo -n "eikä liittäminen onnistunut, "
        echo "joten tämä tyssää nyt tähän."
        return 1
    }
    echo ""
  }
}

function mount_videos_root() {
  mountpoint -q "$KOHDEVIDEO" || { \
    echo -n "Liitän videoiden kohdeaseman ($KOHDEVIDEO)."
    sudo mount "$KOHDEVIDEO" > /dev/null || { \
        echo ""
        echo -n "Videoiden kohdeasema $KOHDEVIDEO ei ole liitettynä "
        echo -n "eikä liittäminen onnistunut, "
        echo "joten tämä tyssää nyt tähän."
        return 1
    }
    echo ""
  }
}

function set_up_target() {
  for KOHDE in $KOHDEROOT $KOHDEHOME $KOHDEPILVI $SNAPROOT $KOHDETYOP # $KOHDEVIDEO
  do
    pushd "$KOHDE" >/dev/null 2>&1 || { \
	echo -n "En päässyt kohdehakemistoon $KOHDE, "
	echo "joten tämä tyssää nyt tähän."
  	return 1
    }
  done
}

function back_up_server() {
  command palvelinbackup.sh --help > /dev/null || { \
	echo -n "En löytänyt palvelinvarmuuskopiointikomentojonoa (palvelinbackup.sh), "
	echo "joten tämä tyssää nyt tähän."
	return 1
  }

  palvelinbackup.sh "${KOHDEROOT}" || { \
	echo -n "Palvelinvarmuuskopiointikomentojono failasi, "
	echo "joten tämä tyssää nyt tähän."
	return 1
  }
}

function trash_trash() {
  echo -n "Heitän geditin luomat varmuuskopiot sun muut roskat pois..."
  cd
  find . -name '*~' -type f -exec gvfs-trash '{}' \;
  find . -name '.comments' -type d -exec gvfs-trash '{}' \;
  find . -maxdepth 1 -mmin +60 -regextype posix-extended -regex '\./\.goutputstream-.{6}' -exec gvfs-trash '{}' \;
  echo " valmis."
}

function empty_trash() {
  echo -n "Tyhjennän roskat..."
  rm -rf ~/.local/share/Trash
  rm -rf ~/Työpöytä/.Trash-1000
  cd
  find . -prune -name ".Trash-$(id -u)" -type d -exec rm -rf '{}' \;
  echo " valmis."
}

function rsync_erred() {
  if [ "$1" == "$VANISHED" ]
  then
    return 1
  fi

  grep -q "No space left on device (28)" "$RSYNCOUTPUT"
  if [ $? -gt 0 ]
  then
	echo " epäonnistui. Virheilmoitus oli:"
	cat "$RSYNCOUTPUT"
  else
	echo " mutta tila loppui kesken."
  fi
  echo "Keskeytetään."
  return 0
}

function back_up_home() {
  echo -n "Varmuuskopioin kotihakemiston... "
  $COUNTDOWN
  cd /home

  rsync -axz --delete --delete-excluded \
    --include "/${CLOUDSUBDIR}/."  --exclude "/${CLOUDSUBDIR}/*" \
    --include "/${TPSUBDIR}/." --exclude "/${TPSUBDIR}/*" \
    --include "/${SNSUBDIR}/." --exclude "/${SNSUBDIR}/*" \
    "${MOI}/" "${KOHDEHOME}/" \
	> "$RSYNCOUTPUT" 2>&1 || { rsync_erred $? && return 1 ; }

  echo " valmis."
}

function back_up_u1() {
  echo -n "Varmuuskopioin pilven... "
  $COUNTDOWN
  cd
  rsync -ax --delete \
    "${CLOUDSUBDIR}/" "${KOHDEPILVI}/" \
	> "$RSYNCOUTPUT" 2>&1 || { rsync_erred $? && return 1 ; }

  echo " valmis."
}

function back_up_etc() {
  echo -n "Tekeydyn pääkäyttäjäksi ja varmuuskopioin asetustiedostot..."
  LC_ALL=C sudo tar cjf "${KOHDEETC}" /etc/ 2>&1 | grep -v "Removing leading"
  sudo chown "${MOI}.${MOI}" "${KOHDEETC}"
  echo " valmis."
}

function back_up_local() {
  echo -n "Tekeydyn pääkäyttäjäksi ja varmuuskopioin paikalliset järjestelmätiedostot..."
  LC_ALL=C sudo tar cjf "${KOHDEUSRL}" /usr/local/ 2>&1 | grep -v "Removing leading"
  sudo chown "${MOI}.${MOI}" "${KOHDEUSRL}"
  echo " valmis."
}

function back_up_desktop() {
  transmission-remote -t all -S
  echo "Varmuuskopioin työpöydän... "
  backintime -b
  echo " valmis."
  transmission-remote -t all -s
}

function back_up_video() {
  echo -n "Varmuuskopioin videot... "
  cd
  rsync -ax --delete \
    --include-from=$VIDEOINCLUDES \
    "${VIDEOSUBDIR}/" "${KOHDEVIDEO}/" \
	> "$RSYNCOUTPUT" 2>&1 || { rsync_erred $? && return 1 ; }

  echo " valmis."
}

function post_status() {
  echo -n "Ilmoitan varmuuskopioinnista mikroblogissa... "
  ilmoitus_varmuuskopioinnista.sh && echo " valmis."
}

function notify() {
  if [ "x$DISPLAY" != "x" ]
  then
  	notify-send -i system-file-manager-panel "Viikottainen varmuuskopiointi" "Varmuuskopiointi valmistui."
  fi
}

mount_snapshot_root || exit 1
set_up_target || exit 1

RESUME=0
if [[ $# -gt 0 && $1 == "--resume" ]]
then
  if ! [ -r "$RESUMEFILE" ]
  then
	echo "Jatkaminen ei onnistu, sillä keskeytynyttä työtä ei löytynyt."
	die 0
  else
	RESUME=$(<"$RESUMEFILE")
	if ! [[ "$RESUME" =~ ^[0-9]+$ ]]
	then
	  echo "Jatkaminen ei onnistu, sillä tieto keskeytyneestä työstä on pilalla."
	  die 0
	fi
  fi
fi

function resume() {
  [ "$RESUME" -lt $(($1 + 1)) ] && { { rm -f "$RESUMEFILE" ; "$2" ; } || die "$1" ; }
}

resume 0 back_up_server
resume 1 trash_trash
resume 2 empty_trash
resume 3 back_up_home
resume 4 back_up_u1
resume 5 back_up_etc
resume 6 back_up_local
resume 7 back_up_desktop
resume 10 post_status
#resume 11 unmount_snapshot_root
notify
echo "Ool dan."
die 0
