#!/bin/bash -i
shopt -s expand_aliases
if [ -f ~/.bash_aliases ]; then
    . ~/.bash_aliases
fi
COUNTDOWN=true
command countdown 0 > /dev/null && COUNTDOWN="countdown 3"

# palvelinbackup.sh to 24.7.2014 13.23.02 +0300
#	- %%/
#
# su 29.12.2013 18.45.31 +0200
#       - ei ilmoituskuplaa jos ei työpöytää
#
# ke 25.12.2013 22.20.35 +0200
#	- salasanakysely komentorivillä jos ei työpöytäympäristöä
#
# ke 11.12.2013 21.56.14 +0200
#	- command whichin sijasta
#
# ke 16.1.2013 20.51.24 +0200:
#	- eriytys viikottainen.sh:sta
#
# ke 16.1.2013 20.51.24 +0200:


if [[ $# -lt 1 ]]
then
	echo -n "Palvelintiedostojen varmuuskopioinnin kohdehakemistoa ei määritelty, "
	echo "joten tämä tyssää nyt tähän."
	exit 1
fi

if [[ "$1" == "--help" ]]
then
	echo "palvelinbackup.sh varmuuskopioiden_tallennushakemistopolku"
	exit 0
fi

KTUN_PALV=mummila
PALVELIN=mummila
TIETOKANTA=mummila
KOHDE=${1%%/}/${KTUN_PALV}
TIETOKANTASALASANAN_ID=16

pushd $KOHDE >/dev/null 2>&1 || { \
	echo -n "En päässyt palvelintiedostojen varmuuskopioinnin kohdehakemistoon ($KOHDE), "
	echo "joten tämä tyssää nyt tähän."
	exit 1
}

if [ "x$DISPLAY" == "x" ]
then
  echo "Työpöytäympäristöä ei havaittu, joten pyydän sinua syöttämään tietokannan salasanan."
  echo -n "Tietokannan salasana: "

  # http://stackoverflow.com/a/2654048
  STTY_ORIG=`stty -g` # save original terminal setting.
  stty -echo          # turn-off echoing.
  read TKSALASANA     # read the password
  stty $STTY_ORIG     # restore terminal setting.

  echo ""
else
  TKSALASANA=`gkeyring --id=$TIETOKANTASALASANAN_ID -o secret`
fi

if [[ "x$TKSALASANA" == "x" ]]
then
	echo -n "En saanut tietokannan salasanaa Gnomen salausavainpalvelusta, "
	echo "joten tämä tyssää nyt tähän."
	exit 1
fi

echo -n "Varmuuskopioin tietokannan..."
$COUNTDOWN
TKDUMPPAUS="mysqldump --opt -u $KTUN_PALV -p$TKSALASANA $TIETOKANTA"
TKKOPIO=$PALVELIN-`datefilename`.sql.bz2
TKVARMUUSKOPIOINTI="$TKDUMPPAUS | bzip2 -9 > $TKKOPIO"
ssh $PALVELIN "$TKVARMUUSKOPIOINTI" || {
	echo " epäonnistui."
	echo "Keskeytetään."
	exit 1
}
echo " valmis."

echo -n "Tyhjennän palvelimelta roskat..."
PALVKOTI="/home/users/$KTUN_PALV/"
PALVROSKAT="${PALVKOTI%%/}/.Trash-`id -u` ${PALVKOTI%%/}/.Trash-`whoami`"
PALVROSKIEN_TYHJENNYS="rm -rf $PALVROSKAT"
PALVROSKAKORIN_LUOMINEN="mkdir ${PALVKOTI%%/}/.Trash-`whoami`"
ssh $PALVELIN "$PALVROSKIEN_TYHJENNYS && $PALVROSKAKORIN_LUOMINEN"
echo " valmis."

#echo -n "Heitän geditin luomat varmuuskopiot pois palvelimelta..."
#ssh $PALVELIN "find . -name '*~' -type f -exec rm '{}' \;"
#echo " valmis."

echo -n "Varmuuskopioin palvelintiedostot... "
$COUNTDOWN
KOHDE=${KOHDE%%/}
rsync -az --delete $PALVELIN:$PALVKOTI $KOHDE/ || {
	echo " epäonnistui."
	echo "Keskeytetään."
	exit 1
}

ssh $PALVELIN "rm -f ${TKKOPIO}"
echo " valmis."

popd >/dev/null 2>&1

if [ "x$DISPLAY" != "x" ]
then
	notify-send -i system-file-manager-panel "Palvelintiedostojen varmuuskopiointi" "Varmuuskopiointi valmistui."
fi
