#!/bin/sh
 
#
# summon.sh - Brings application window to current workspace or starts the
#             application if it isn't running. Intended for use with Gnome and
#             Compiz.
#
# Usage: summon.sh <window title> <program> [arguments]...
#
#        <window title> is the title (or a substring of it) of the window to be
#        found.
#
#        <program> is the application to run if no window is found. May be
#        followed by arguments.
#
 
SELF=`basename $0`
 
if [ $# -lt 2 ]; then
    cat <<END
Usage: $SELF <window title> <program> [arguments]...
 
    Brings application window to current workspace or starts the application if
    it isn't running. Intended for use with Gnome and Compiz.
 
    <window title> is the title (or a substring of it) of the window to be
    found.
 
    <program> is the application to run if no window is found. May be followed
    by arguments.
END
    exit 1
fi
 
TITLE_SUBSTR=$1
shift
 
# Check if the application is running
WINDOW_ID=`wmctrl -l | grep "$TITLE_SUBSTR" | sed -r 's/\s.*//'`
 
if [ -z $WINDOW_ID ]; then
    # Not running -- start it
    exec $@
else
    # Application is running -- its window is $WINDOW_ID
 
    # Get the dimensions of a single workspace
    XDPYINFO_OUT=`xdpyinfo | grep 'dimensions:'`
    WORKSPACE_WIDTH=`echo "$XDPYINFO_OUT" | sed -r 's/.*:\s+([0-9]+)x.*/\1/'`
    WORKSPACE_HEIGHT=`echo "$XDPYINFO_OUT" \
        | sed -r 's/.*:\s+[0-9]+x([0-9]+).*/\1/'`
 
    # Get the X and Y offset of the current workspace
    XPROP_OUT=`xprop -root -notype _NET_DESKTOP_VIEWPORT`
    CURRENT_X=`echo "$XPROP_OUT" | sed -r 's/.*= ([0-9]+),.*/\1/'`
    CURRENT_Y=`echo "$XPROP_OUT" | sed -r 's/.*= [0-9]+,\s*([0-9]+).*/\1/'`
 
    # Get the coordinates of the top left corner of KeePassX window
    XWININFO_OUT=`xwininfo -id "$WINDOW_ID"`
    WINDOW_X=`echo "$XWININFO_OUT" | grep 'Absolute upper-left X' \
        | sed -r 's/.*:\s+([0-9-]+).*/\1/'`
    WINDOW_Y=`echo "$XWININFO_OUT" | grep 'Absolute upper-left Y' \
        | sed -r 's/.*:\s+([0-9-]+).*/\1/'`
 
    # Calculate the new location of the window
    NEW_WINDOW_X=`echo "($CURRENT_X + ($WINDOW_X)) % $WORKSPACE_WIDTH" | bc`
    NEW_WINDOW_Y=`echo "($CURRENT_Y + ($WINDOW_Y)) % $WORKSPACE_HEIGHT" | bc`
 
    # Move the window to the new location and raise it
    wmctrl -i -r "$WINDOW_ID" -e 10,"$NEW_WINDOW_X","$NEW_WINDOW_Y",-1,-1
    wmctrl -i -R "$WINDOW_ID"
fi