// ==UserScript==
// @name          Chrome Shift+Enter New Window Blocker 
// @namespace     http://www.joetotaro.net
// @description   Stops Chrome from opening a new window when on SHIFT+ENTER. Instead submits the form.
// @copyright     Joe Totaro (tweaked by Jani Uusitalo)
// @license       MIT License; http://www.opensource.org/licenses/mit-license.php
// @include       *
// ==/UserScript==


function supressShiftEnter(event){
  //shift enter is pressed
  if(event.keyCode == 13 && event.shiftKey){
    var form = event.srcElement.form;
    //try to submit the form
    try{
      if(typeof form.submit == 'function')
        form.submit();
      else 
        form.submit.click();
    }
    finally{
      return false;
    }
  }
  return true;
}

var inputs = document.getElementsByTagName('input');
    
for (var i = 0; i < inputs.length; i++){
  inputs[i].onkeypress = supressShiftEnter;
}
