// new edit toolbar used with permission
// by Alex King
// http://www.alexking.org/

var edButtons = new Array();
var edLinks = new Array();
var edOpenTags = new Array();

function edButton(id, display, tagStart, tagEnd, access, open) {
	this.id = id;				// used to name the toolbar button
	this.display = display;		// label on button
	this.tagStart = tagStart; 	// open tag
	this.tagEnd = tagEnd;		// close tag
	this.access = access;		// access key
	this.open = open;			// set to -1 if tag does not need to be closed
}

function zeroise(number, threshold) {
	// FIXME: or we could use an implementation of printf in js here
	var str = number.toString();
	if (number < 0) { str = str.substr(1, str.length) }
	while (str.length < threshold) { str = "0" + str }
	if (number < 0) { str = '-' + str }
	return str;
}

var now = new Date();
var datetime = now.getUTCFullYear() + '-' + 
zeroise(now.getUTCMonth() + 1, 2) + '-' +
zeroise(now.getUTCDate(), 2) + 'T' + 
zeroise(now.getUTCHours(), 2) + ':' + 
zeroise(now.getUTCMinutes(), 2) + ':' + 
zeroise(now.getUTCSeconds() ,2) + '+00:00';

function getTimeNow() {
	var d = new Date();
	var minutesNow = zeroise(d.getMinutes(), 2);
	var hoursNow = d.getHours();
	var dateNow = d.getDate();
	var monthNow = (d.getMonth()) + 1;
	var yearNow = d.getFullYear();
	var timeNow = dateNow + '.' + monthNow + '.' + yearNow + ' ' + hoursNow + ':' + minutesNow;
	return timeNow;
}

edButtons[edButtons.length] = 
new edButton('ed_b'
,'b'
,'<b>'
,'</b>'
,'b'
);

edButtons[edButtons.length] = 
new edButton('ed_i'
,'i'
,'<i>'
,'</i>'
,'i'
);

edButtons[edButtons.length] = 
new edButton('ed_strong'
,'strong'
,'<strong>'
,'</strong>'
,'s'
);

edButtons[edButtons.length] = 
new edButton('ed_em'
,'em'
,'<em>'
,'</em>'
,'e'
);

edButtons[edButtons.length] = 
new edButton('ed_uppercase'
,'a&rarr;A'
,'<span style="text-transform: uppercase;">'
,'</span>'
,'u'
);

edButtons[edButtons.length] = 
new edButton('ed_link'
,'link'
,''
,'</a>'
,'a'
); // special case


edButtons[edButtons.length] = 
new edButton('ed_del'
,'del'
,'<del datetime="' + datetime + '">'
,'</del>'
,'d'
);

edButtons[edButtons.length] = 
new edButton('ed_ins'
,'ins'
,'<ins datetime="' + datetime + '">'
,'</ins>'
,'s'
);

edButtons[edButtons.length] = 
new edButton('ed_timestamp'
,'timestamp'
,''
,''
,'t'
);

edButtons[edButtons.length] = 
new edButton('ed_history'
,'history'
,''
,''
,'h'
);

edButtons[edButtons.length] = 
new edButton('ed_historyEdit'
,'edit'
,''
,''
,'e'
);

edButtons[edButtons.length] = 
new edButton('ed_historyEditAt'
,'at'
,''
,''
,'A'
);

edButtons[edButtons.length] = 
new edButton('ed_lang'
,'lang='
,''
,'</span>'
,'l'
);

function edLink() {
	this.display = '';
	this.URL = '';
	this.newWin = 0;
}

edLinks[edLinks.length] = new edLink('WordPress'
                                    ,'http://wordpress.org/'
                                    );

edLinks[edLinks.length] = new edLink('alexking.org'
                                    ,'http://www.alexking.org/'
                                    );

function edShowButton(button, i) {
	if (button.id == 'ed_img') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edInsertImage(edCanvas);" value="' + button.display + '" />');
	}
	else if (button.id == 'ed_link') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edInsertLink(edCanvas, ' + i + ');" value="' + button.display + '" />');
	}
	else if (button.id == 'ed_lang') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edSpanLang(edCanvas, ' + i + ');" value="' + button.display + '" />\n<form>\n<select id="edLang">\n<option value="en">en: English</option>\n<option value="fr">fr: French</option>\n<option value="de">de: German</option>\n<option value="fi">fi: Finnish</option>\n<option value="sv">sv: Swedish</option>\n</select>\n</form>');
	}
	else if (button.id == 'ed_timestamp') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edTimeStamp(edCanvas, ' + i + ');" value="' + button.display + '" />');
	}
	else if (button.id == 'ed_history') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edHistory(edCanvas, ' + i + ');" value="' + button.display + '" />');
	}
	else if (button.id == 'ed_historyEdit') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edHistoryEdit(edCanvas, ' + i + ');" value="' + button.display + '" />');
	}
	else if (button.id == 'ed_historyEditAt') {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edHistoryEditAt(edCanvas, ' + i + ');" value="' + button.display + '" />');
	}
	else {
		document.write('<input type="button" id="' + button.id + '" accesskey="' + button.access + '" class="ed_button" onclick="edInsertTag(edCanvas, ' + i + ');" value="' + button.display + '"  />');
	}
}

function edTimeStamp(myField, i) {
	var timeNow = getTimeNow();
	edButtons[i].tagStart = timeNow;
	edInsertTag(myField, i);
}

function edHistory(myField, i) {
	var timeNow = getTimeNow();
	if (!edCheckOpenTags(i)) {
		edButtons[i].tagStart = '<history>\n <edit><at>' + timeNow + '</at> </edit>\n</history>\n';
		edInsertTag(myField, i);
	}
	else {
		edInsertTag(myField, i);
	}
}

function edHistoryEdit(myField, i) {
	var timeNow = getTimeNow();
	if (!edCheckOpenTags(i)) {
		edButtons[i].tagStart = ' <edit><at>' + timeNow + '</at> </edit>\n';
		edInsertTag(myField, i);
	}
	else {
		edInsertTag(myField, i);
	}
}

function edHistoryEditAt(myField, i) {
	var timeNow = getTimeNow();
	if (!edCheckOpenTags(i)) {
		edButtons[i].tagStart = '<at>' + timeNow + '</at> ';
		edInsertTag(myField, i);
	}
	else {
		edInsertTag(myField, i);
	}
}

function edSpanLang(myField, i) {
	var langSelect = document.getElementById('edLang');
	var langLang = langSelect.options[langSelect.selectedIndex].value;
	if (!edCheckOpenTags(i)) {
		edButtons[i].tagStart = '<span lang="' + langLang + '">';
		edInsertTag(myField, i);
	}
	else {
		edInsertTag(myField, i);
	}
}

function edShowLinks() {
	var tempStr = '<select onchange="edQuickLink(this.options[this.selectedIndex].value, this);"><option value="-1" selected>' + quicktagsL10n.quickLinks + '</option>';
	for (i = 0; i < edLinks.length; i++) {
		tempStr += '<option value="' + i + '">' + edLinks[i].display + '</option>';
	}
	tempStr += '</select>';
	document.write(tempStr);
}

function edAddTag(button) {
	if (edButtons[button].tagEnd != '') {
		edOpenTags[edOpenTags.length] = button;
		document.getElementById(edButtons[button].id).value = '/' + document.getElementById(edButtons[button].id).value;
	}
}

function edRemoveTag(button) {
	for (i = 0; i < edOpenTags.length; i++) {
		if (edOpenTags[i] == button) {
			edOpenTags.splice(i, 1);
			document.getElementById(edButtons[button].id).value = 		document.getElementById(edButtons[button].id).value.replace('/', '');
		}
	}
}

function edCheckOpenTags(button) {
	var tag = 0;
	for (i = 0; i < edOpenTags.length; i++) {
		if (edOpenTags[i] == button) {
			tag++;
		}
	}
	if (tag > 0) {
		return true; // tag found
	}
	else {
		return false; // tag not found
	}
}

function edCloseAllTags() {
	var count = edOpenTags.length;
	for (o = 0; o < count; o++) {
		edInsertTag(edCanvas, edOpenTags[edOpenTags.length - 1]);
	}
}

function edQuickLink(i, thisSelect) {
	if (i > -1) {
		var newWin = '';
		if (edLinks[i].newWin == 1) {
			newWin = ' target="_blank"';
		}
		var tempStr = '<a href="' + edLinks[i].URL + '"' + newWin + '>' 
		            + edLinks[i].display
		            + '</a>';
		thisSelect.selectedIndex = 0;
		edInsertContent(edCanvas, tempStr);
	}
	else {
		thisSelect.selectedIndex = 0;
	}
}

function edSpell(myField) {
	var word = '';
	if (document.selection) {
		myField.focus();
	    var sel = document.selection.createRange();
		if (sel.text.length > 0) {
			word = sel.text;
		}
	}
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		if (startPos != endPos) {
			word = myField.value.substring(startPos, endPos);
		}
	}
	if (word == '') {
		word = prompt(quicktagsL10n.wordLookup, '');
	}
	if (word !== null && /^\w[\w ]*$/.test(word)) {
		window.open('http://www.answers.com/' + escape(word));
	}
}

function edToolbar() {
	document.write('<div id="ed_toolbar">');
	for (i = 0; i < edButtons.length; i++) {
		edShowButton(edButtons[i], i);
	}
/*	document.write('<input type="button" id="ed_spell" class="ed_button" onclick="edSpell(edCanvas);" title="' + quicktagsL10n.dictionaryLookup + '" value="' + quicktagsL10n.lookup + '" />');  */
	document.write('<input type="button" id="ed_close" class="ed_button" onclick="edCloseAllTags();" title="' + quicktagsL10n.closeAllOpenTags + '" value="' + quicktagsL10n.closeTags + '" />');
//	edShowLinks(); // disabled by default
	document.write('</div>');
}

// insertion code

function edInsertTag(myField, i) {
	//IE support
	if (document.selection) {
		myField.focus();
	    sel = document.selection.createRange();
		if (sel.text.length > 0) {
			sel.text = edButtons[i].tagStart + sel.text + edButtons[i].tagEnd;
		}
		else {
			if (!edCheckOpenTags(i) || edButtons[i].tagEnd == '') {
				sel.text = edButtons[i].tagStart;
				edAddTag(i);
			}
			else {
				sel.text = edButtons[i].tagEnd;
				edRemoveTag(i);
			}
		}
		myField.focus();
	}
	//MOZILLA/NETSCAPE support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		var cursorPos = endPos;
		var scrollTop = myField.scrollTop;

		if (startPos != endPos) {
			myField.value = myField.value.substring(0, startPos)
			              + edButtons[i].tagStart
			              + myField.value.substring(startPos, endPos) 
			              + edButtons[i].tagEnd
			              + myField.value.substring(endPos, myField.value.length);
			cursorPos += edButtons[i].tagStart.length + edButtons[i].tagEnd.length;
		}
		else {
			if (!edCheckOpenTags(i) || edButtons[i].tagEnd == '') {
				myField.value = myField.value.substring(0, startPos) 
				              + edButtons[i].tagStart
				              + myField.value.substring(endPos, myField.value.length);
				edAddTag(i);
				cursorPos = startPos + edButtons[i].tagStart.length;
			}
			else {
				myField.value = myField.value.substring(0, startPos) 
				              + edButtons[i].tagEnd
				              + myField.value.substring(endPos, myField.value.length);
				edRemoveTag(i);
				cursorPos = startPos + edButtons[i].tagEnd.length;
			}
		}
		myField.focus();
		myField.selectionStart = cursorPos;
		myField.selectionEnd = cursorPos;
		myField.scrollTop = scrollTop;
	}
	else {
		if (!edCheckOpenTags(i) || edButtons[i].tagEnd == '') {
			myField.value += edButtons[i].tagStart;
			edAddTag(i);
		}
		else {
			myField.value += edButtons[i].tagEnd;
			edRemoveTag(i);
		}
		myField.focus();
	}
}

function edInsertContent(myField, myValue) {
	//IE support
	if (document.selection) {
		myField.focus();
		sel = document.selection.createRange();
		sel.text = myValue;
		myField.focus();
	}
	//MOZILLA/NETSCAPE support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		myField.value = myField.value.substring(0, startPos)
		              + myValue 
                      + myField.value.substring(endPos, myField.value.length);
		myField.focus();
		myField.selectionStart = startPos + myValue.length;
		myField.selectionEnd = startPos + myValue.length;
	} else {
		myField.value += myValue;
		myField.focus();
	}
}

function edInsertLink(myField, i, defaultValue) {
	if (!defaultValue) {
		defaultValue = 'http://';
	}
	if (!edCheckOpenTags(i)) {
		var URL = prompt(quicktagsL10n.enterURL, defaultValue);
		if (URL) {
			edButtons[i].tagStart = '<a href="' + URL + '">';
			edInsertTag(myField, i);
		}
	}
	else {
		edInsertTag(myField, i);
	}
}

function edInsertImage(myField) {
	var myValue = prompt(quicktagsL10n.enterImageURL, 'http://');
	if (myValue) {
		myValue = '<img src="' 
				+ myValue 
				+ '" alt="' + prompt(quicktagsL10n.enterImageDescription, '') 
				+ '" />';
		edInsertContent(myField, myValue);
	}
}