<?php
/*************************************************************************************
 * udev.php
 * ------
 * Author: Jani Uusitalo (jani@mummila.net)
 * Copyright: (c) 2012 Jani Uusitalo
 * Release Version: 1.0.8.11
 * Date Started: 2012/11/09
 *
 * Udev rule language file for GeSHi.
 *
 * CHANGES
 * -------
 * 2012/11/09
 *   -  Branched from 4CS
 *
 * TODO (updated 2012/11/09)
 * -------------------------
 *
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/

$language_data = array (
    'LANG_NAME' => 'udev',
    'COMMENT_SINGLE' => array(1 => "#"),
    'COMMENT_MULTI' => array(),
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'QUOTEMARKS' => array('"'),
    'ESCAPE_CHAR' => '',
    'KEYWORDS' => array(
        1 => array(
            'ACTION', 'DEVPATH', 'KERNEL', 'NAME', 'SYMLINK',
            'SUBSYSTEM', 'DRIVER', 'KERNEL', 'SUBSYSTEMS',
            'DRIVERS', 'ATTRS', 'TAGS', 'ENV', 'TAG', 'TEST',
            'PROGRAM', 'RESULT', 
            ),
        2 => array(
            'NAME', 'SYMLINK', 'OWNER', 'GROUP', 'MODE',
            'ATTR', 'ENV', 'TAG', 'RUN', 'LABEL', 'GOTO',
            'IMPORT', 'WAIT_FOR', 'OPTIONS'
            ),
        3 => array(
            'program', 'file', 'db', 'cmdline', 'parent',
            'link_priority', 'event_timeout', 'string_escape',
            'static_node', 'watch', 'nowatch'
        ),
        4 => array(
            '%kernel', '%k', '%number', '%n', '%devpath', '%p',
            '%id', '%b', '%driver', '%attr', '%s', 
            '%env', '%E', '%major', '%M', '%minor', '%m',
            '%result', '%c', '%parent', '%P',
            '%name', '%links', '%root', '%r',
            '%sys', '%S', '%tempmode', '%N'
        )
    ),
    'SYMBOLS' => array(
        0 => array(
            ',', '*', '?'
        ),
        1 => array(
            '{', '}', '[', ']',
        ),
        2 => array(
            '==', '!=', '=', '+=', ':='
        ),
        3 => array(
            '%%', '$$'
        ),
    ),
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        1 => true,
        2 => true,
        3 => true,
        4 => true
    ),
    'STYLES' => array(
        'KEYWORDS' => array(
            1 => 'color: #0000C0; font-weight: bold;',
            2 => 'color: #800080;',
            3 => 'color: #009966; font-style: italic;',
            4 => 'color: #666666;',
            ),
        'COMMENTS' => array(
            1 => 'color: #008000;'
            ),
        'BRACKETS' => array(
            0 => 'color: #000080;'
            ),
        'STRINGS' => array(
            0 => 'color: #808080;'
            ),
        'NUMBERS' => array(
            0 => 'color: #cc66cc;'
            ),
        'METHODS' => array(
            1 => 'color: #66cc66;'
            ),
        'SYMBOLS' => array(
            0 => 'color: #000080;'
            ),
        'ESCAPE_CHAR' => array(
            0 => 'color: #000099;'
            ),
        'SCRIPT' => array(
            ),
        'REGEXPS' => array(
            )
        ),
    'URLS' => array(
        1 => '',
        2 => '',
        3 => '',
        4 => ''
        ),
    'OOLANG' => false,
    'OBJECT_SPLITTERS' => array(),
    'REGEXPS' => array(
        ),
    'STRICT_MODE_APPLIES' => GESHI_NEVER,
    'SCRIPT_DELIMITERS' => array(
        ),
    'HIGHLIGHT_STRICT_BLOCK' => array(
        )
);

?>
