#include <stdio.h>
#include <stdlib.h>
#include <linux/input.h>
#include <sys/types.h>
#include <fcntl.h>
#include <X11/extensions/XTest.h>

Display *dpy;
int file;

void cleanup()
{
    if(file) {
        close(file);
    }
    if(dpy) {
        XCloseDisplay(dpy); 
    }
}

int main(int argc, const char** argv)
{
    if(argc < 3) {
        printf("Usage: %s <event_device> <how_many_times_faster>\n", argv[0]);
        return 1;
    }

    atexit(cleanup);
    if((file = open(argv[1], O_RDONLY)) <= 0) {
        perror("open");
        return 2;
    }
    struct input_event event;
    if ((dpy = XOpenDisplay(NULL)) == NULL) {
        fprintf(stderr, "Can't open display\n"); 
        return 3;
    }

    int times = atoi(argv[2]) - 1;
    size_t n;
    while((n = read(file, &event, sizeof(struct input_event)))>0) {
        if(event.type == EV_REL) {
            if (event.code == REL_WHEEL) {
                if(event.value > 0) {
                    int i = 0;
                    for (; i < times; i++) {
                        XTestFakeButtonEvent(dpy, 4, True, CurrentTime);
                        XTestFakeButtonEvent(dpy, 4, False, CurrentTime);
                    }
                } else {
                    int i = 0;
                    for (; i < times; i++) {
                        XTestFakeButtonEvent(dpy, 5, True, CurrentTime);
                        XTestFakeButtonEvent(dpy, 5, False, CurrentTime);
                    }
                }
                XFlush(dpy);
            } else if(event.code == REL_HWHEEL) {
                if(event.value > 0) {
                    int i = 0;
                    for (; i < times; i++) {
                        XTestFakeButtonEvent(dpy, 7, True, CurrentTime);
                        XTestFakeButtonEvent(dpy, 7, False, CurrentTime);
                    }
                } else {
                    int i = 0;
                    for (; i < times; i++) {
                        XTestFakeButtonEvent(dpy, 6, True, CurrentTime);
                        XTestFakeButtonEvent(dpy, 6, False, CurrentTime);
                    }
                }
                XFlush(dpy);
            }
        }

    }
    return 0;
}
}